// app/wave_engine.js
import { tau } from "./core/derived.js";
import { makeTruthAccessor } from "./time_domain.js";

// Builds wave arrays for the scope, depending on mode/topology.
// Architecture:
// - truth access (time-domain sampler) lives in time_domain.js (physics-layer)
// - wave_engine is now ONLY "array construction" (no topology math inside)
export function buildWaves({ tStart, span, N }){
  const dt = span / Math.max(1, (N - 1));

  const vSrc = new Array(N);
  const i    = new Array(N);
  const vL   = new Array(N);
  const vC   = new Array(N); // optional, may stay 0 for RL

  const tt = tau();

  const acc = makeTruthAccessor();
  const hasVC = !!acc?.hasVC;

  for(let k = 0; k < N; k++){
    const t = tStart + k*dt;
    const s = acc.sampleAt(t);

    vSrc[k] = s.vSrc;
    i[k]    = s.i;
    vL[k]   = s.vL;
    vC[k]   = s.vC;
  }

  return { dt, tau: tt, vSrc, i, vL, vC, hasVC };
}