// state.js
// Mutable simulator state only.
// NOTE: derived helpers (tau/Rtotal/period/duty) live in ./core/derived.js

export const state = {
  // runtime / UI
  hold: false,

  // RL
  L: 0.010,
  Rcoil: 4.25,
  Rload: 2.05,

  // RLC
  C: 0.0000025,                 // Farads (SI). Step-1: only used for sine series RLC.
  topology: "seriesRLC", // "seriesRLC" | later: "C_parallel_RL"

  // shared amplitude (peak)
  V: 100,

  // pulse
  f: 200,
  dutyPct: 5.0,

  // sine
  fs: 200,

  // ui
  timeDiv_ms: 1.0,

  // mode
  srcMode: 'sine', // 'pulse' | 'sine'

  // reference snapshot
  refSnapshot: null,
};