// rl_sine.js
import { state } from "./state.js";
import { Rtotal } from "./core/derived.js";

export function sineParams(){
  const w = 2*Math.PI*Math.max(1e-12, state.fs);
  const R = Rtotal();
  const XL = w*state.L;
  const Z = Math.sqrt(R*R + XL*XL);
  const phi = Math.atan2(XL, R);
  const Ipk = (state.V / Math.max(1e-12, Z));
  const Irms = Ipk/Math.SQRT2;
  const Vrms = state.V/Math.SQRT2;
  return { w, R, XL, Z, phi, Ipk, Irms, Vrms };
}
