// panels/periodicity_badge.js
import { periodicityErrorPulse } from "../metrics.js";

export function updatePeriodicityBadge(){
  const el = document.getElementById("periodBadge");
  if(!el) return;

  const p = periodicityErrorPulse();

  // not applicable (sine mode / no C / unsupported topology)
  if(!p || !isFinite(p.errAbs)){
    el.textContent = "PERIODICITY: —";
    el.classList.remove("ok","warn","bad");
    return;
  }

  const e = Math.abs(p.errAbs);

  // thresholds (tune if you want)
  const OK_THR   = 1e-9;
  const WARN_THR = 1e-6;

  let cls = "bad";
  let icon = "■";
  if(e < OK_THR){ cls = "ok"; icon = "●"; }
  else if(e < WARN_THR){ cls = "warn"; icon = "▲"; }

  el.classList.remove("ok","warn","bad");
  el.classList.add(cls);

  el.textContent = `PERIODICITY: ${e.toExponential(2)} ${icon}`;
  el.title = `Pulse periodicity error (abs): ${e.toExponential(6)} · topology=${p.topology}`;
}