// panels/meters.js
import { $, fmt } from "../dom.js";
import { state } from "../state.js";

export function updateMeter(nowImpulse){
  const pctEl = $('#cemfPct');
  const bar = $('#cemfBar');
  const refEl = $('#cemfRef');
  const nowEl = $('#cemfNow');
  const callout = $('#callout');

  if(!isFinite(nowImpulse)){
    if(nowEl) nowEl.textContent = '—';
    return;
  }
  if(nowEl) nowEl.textContent = `${nowImpulse.toExponential(3)} V·s`;

  if(!state.refSnapshot || !isFinite(state.refSnapshot.impulse)){
    if(pctEl) pctEl.textContent = `${nowImpulse.toExponential(3)} V·s`;
    if(refEl) refEl.textContent = '—';
    if(bar){
      bar.style.width = '0%';
      bar.style.background = 'rgba(151,166,178,.25)';
    }
    if(callout) callout.textContent = 'This is the absolute ∫|vL|dt (0→τ). Press Set Ref to show Δ%.';
    return;
  }

  const ref = state.refSnapshot.impulse;
  if(ref === 0){ if(pctEl) pctEl.textContent = '—'; return; }

  if(refEl) refEl.textContent = `${ref.toExponential(3)} V·s`;

  const delta = (nowImpulse/ref - 1)*100;
  if(pctEl) pctEl.textContent = `${delta >= 0 ? '+' : ''}${delta.toFixed(1)}%`;

  if(bar){
    const u = Math.max(0, Math.min(1, (delta + 100) / 200));
    bar.style.width = `${(u*100).toFixed(1)}%`;
  }

  if(callout){
    if(delta < -5) callout.textContent = 'Counter-EMF action reduced (weaker opposition).';
    else if(delta > 5) callout.textContent = 'Counter-EMF action increased (stronger opposition).';
    else callout.textContent = 'Near reference.';
  }
}

export function updatePkVLmeter(nowPkVL){
  const pctEl = $('#pkvlPct');
  const bar = $('#pkvlBar');
  const refEl = $('#pkvlRef');
  const nowEl = $('#pkvlNow');
  const callout = $('#pkvlCallout');

  if(!isFinite(nowPkVL)){
    if(nowEl) nowEl.textContent = '—';
    return;
  }
  if(nowEl) nowEl.textContent = `${fmt(nowPkVL)} V`;

  if(!state.refSnapshot || !isFinite(state.refSnapshot.pkVL)){
    if(pctEl) pctEl.textContent = 'Set Ref';
    if(refEl) refEl.textContent = '—';
    if(bar){
      bar.style.width = '0%';
      bar.style.background = 'rgba(151,166,178,.25)';
    }
    if(callout) callout.textContent = 'Press Set Ref to compare.';
    return;
  }

  const ref = state.refSnapshot.pkVL;
  if(ref === 0){ if(pctEl) pctEl.textContent = '—'; return; }

  if(refEl) refEl.textContent = `${fmt(ref)} V`;

  const delta = (nowPkVL/ref - 1)*100;
  if(pctEl) pctEl.textContent = `${delta >= 0 ? '+' : ''}${delta.toFixed(1)}%`;

  if(bar){
    const u = Math.max(0, Math.min(1, (delta + 100) / 200));
    bar.style.width = `${(u*100).toFixed(1)}%`;
  }

  if(callout){
    if(delta < -5) callout.textContent = 'Peak back-EMF reduced.';
    else if(delta > 5) callout.textContent = 'Peak back-EMF increased.';
    else callout.textContent = 'Near reference.';
  }
}