// panels.js (HUB)
// Purpose: stable public API re-export + orchestration

// --- import locally ---
import { updatePeriodicityBadge } from "./panels/periodicity_badge.js";
import { updatePowerPanel }       from "./panels/power_panel.js";
import { updateMeter, updatePkVLmeter } from "./panels/meters.js";
import { updateDerived }          from "./panels/derived_panel.js";
import { updateMeasStrip }        from "./panels/meas_strip.js";

// --- re-export publicly (API stays stable) ---
export {
  updatePeriodicityBadge,
  updatePowerPanel,
  updateMeter,
  updatePkVLmeter,
  updateDerived,
  updateMeasStrip
};

// --- orchestrator ---
export function updateAllPanels(){
  updateMeasStrip();
  updatePowerPanel();
  updateDerived();
}