// metrics.js
// PUBLIC API HUB ONLY (stable surface).
// Re-exports modular metric domains.
// No heavy logic, no numeric infrastructure, no physics kernels (except pass-through via modules).

export { rlcBreakdownSine, rlcBreakdownFundamental } from "./metrics/rlc_breakdown.js";
export { resonanceHarmonicsLine } from "./metrics/status_line.js";
export { harmonicMetricsPulse } from "./metrics/harmonics.js";
export { powerQualityMetrics } from "./metrics/pq.js";
export { powerSplit, energyFlowMetrics } from "./metrics/energy.js";
export { periodicityErrorPulse } from "./metrics/periodicity.js";

// Measurement model (instrument interpretation)
export {
  sineParamsAny,
  windowMagneticMetrics,
  windowCapacitorMetrics,
  impulse_abs_vL_0_to,
  peak_abs_vL_0_to
} from "./metrics/measurement.js";