// app/index.js
// Single barrel export for the whole app.
// IMPORTANT: keep low-level modules first, high-level last to reduce circular pain.

// Low-level utils
export * from "./dom.js";

// State (mutable)
export * from "./state.js";

// Derived helpers (pure, DOM-free)
export * from "./core/derived.js";

// Math utils (pure, DOM-free)
export * from "./core/math.js";

// Physics kernels
export * from "./rl_pulse.js";
export * from "./rl_sine.js";
export * from "./rlc_sine.js";
export * from "./rlc_pulse.js";

// Wave engine
export * from "./wave_engine.js";

// Derived metrics (uses state + physics)
export * from "./metrics.js";

// DOM panels (uses metrics + state)
export * from "./panels.js";

// Rendering (uses metrics + panels)
export * from "./scope.js";

// UI bindings (uses rendering hooks + metrics)
export * from "./ui.js";
