// dom.js
export const $ = (s)=>document.querySelector(s);

export function fmtJ(J){
  if(!isFinite(J)) return '—';
  const a = Math.abs(J);
  if(a >= 1) return J.toFixed(3)+' J';
  if(a >= 1e-3) return (J*1e3).toFixed(3)+' mJ';
  if(a >= 1e-6) return (J*1e6).toFixed(3)+' µJ';
  return J.toExponential(3)+' J';
}

export function fmt(x, unit=''){
  if(!isFinite(x)) return '—';
  const ax = Math.abs(x);
  if(ax >= 1000) return x.toFixed(0)+unit;
  if(ax >= 10) return x.toFixed(2)+unit;
  if(ax >= 1) return x.toFixed(3)+unit;
  if(ax >= 1e-3) return x.toExponential(2)+unit;
  return x.toExponential(3)+unit;
}

export function clamp(x,a,b){ return Math.min(b, Math.max(a,x)); }

export function logMap(u, a, b){
  const la = Math.log(a), lb = Math.log(b);
  return Math.exp(la + (lb-la)*u);
}

export function invLogMap(x, a, b){
  const la = Math.log(a), lb = Math.log(b);
  return (Math.log(x)-la)/(lb-la);
}

export function fmtDivMs(ms){
  const s = ms * 1e-3;
  if(s < 1e-6) return `${(s*1e9).toFixed(1)} ns/div`;
  if(s < 1e-3) return `${(s*1e6).toFixed(2)} µs/div`;
  if(s < 1)    return `${(s*1e3).toFixed(2)} ms/div`;
  return `${s.toFixed(3)} s/div`;
}

export function flashButton(el, text){
  if(!el) return;
  const old = el.textContent;
  el.textContent = text;
  el.style.filter = 'brightness(1.15)';
  setTimeout(()=>{ el.textContent = old; el.style.filter=''; }, 650);
}

export function bindPair(rangeId, numId, onChange){
  const r = $(rangeId), n = $(numId);
  if(!r || !n) return;

  const sync = (fromRange)=>{
    const v = parseFloat(fromRange ? r.value : n.value);
    r.value = v; 
    n.value = v;
    onChange(v);
  };

  r.addEventListener('input', ()=>sync(true));
  n.addEventListener('input', ()=>sync(false));

  sync(false); // take number box as truth on load
}

