// core/math.js
// Small, reusable math utilities (DOM-free).

export function clamp(x, a, b){
  return Math.min(b, Math.max(a, x));
}

export function safeDiv(a, b, eps = 1e-12){
  const d = Math.abs(b) < eps ? (b < 0 ? -eps : eps) : b;
  return a / d;
}

export function linspace(t0, t1, N){
  const n = Math.max(2, (N|0));
  const out = new Float64Array(n);
  const dt = (t1 - t0) / (n - 1);
  for(let k=0;k<n;k++) out[k] = t0 + k*dt;
  return out;
}

export function mean(arr){
  const n = arr?.length ?? 0;
  if(n <= 0) return 0;
  let s = 0;
  for(let i=0;i<n;i++) s += arr[i];
  return s / n;
}

export function mean2(arr){
  const n = arr?.length ?? 0;
  if(n <= 0) return 0;
  let s = 0;
  for(let i=0;i<n;i++){
    const x = arr[i];
    s += x*x;
  }
  return s / n;
}

export function rms(arr){
  return Math.sqrt(mean2(arr));
}