// core/derived.js
// Pure derived helpers based on the mutable `state`.
// IMPORTANT: this module must remain DOM-free and side-effect free.

import { state } from "../state.js";

export function Rtotal(){
  const rc = Math.max(0, state.Rcoil);
  const rl = Math.max(0, state.Rload);
  return Math.max(1e-12, rc + rl);
}

export function tau(){
  return state.L / Rtotal();
}

export function periodPulse(){
  return 1 / Math.max(1e-12, state.f);
}

export function periodSine(){
  return 1 / Math.max(1e-12, state.fs);
}

export function duty(){
  // Keep duty below 1 to avoid degenerate math in pulse steady-state.
  return Math.max(0, Math.min(0.9, state.dutyPct / 100));
}